#!/usr/bin/perl 
#------------------------------------------------------------------------------
# curl::gui
# A graphical user interface for curl (download only)     
#
# Copyright (C) 2007 Rudolf Martin 
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
# more details. 
#
# 
# Homepage: www.martin-achern.de/wgetgui/        
# Email: wgetgui@martin-achern.de
#
#------------------------------------------------------------------------------

use Tk;
use strict;
use warnings;

my $version="0.1beta";




my $proxy_url;
my $proxy_port;
my $proxy_user;
my $proxy_passw;
my @options;



##------------------------------------------------------------------------------
#--- GUI creation
my $mw = new MainWindow;
$mw->title("curl::GUI (download only)  ".$version);


#------------------------------------------------------------------------------
# frame mode 
#
my $frame_mode = $mw->Frame(-relief=>"groove",
                           -borderwidth => "2")
                   ->pack(-side=>'top',
                    -fill=>'x',
               );

   my $frame_mode_url = $frame_mode->Frame()
                                 ->pack(-fill=>'x');
      
    my $ent_url = $frame_mode_url->Entry(-width=>50,)
                          ->pack(-side => 'left',
                                 -fill=>'x',
                     -expand=>'1',
                            );
  $frame_mode_url->Button(-text => "Clear",
                     -command => sub { $ent_url->delete('0', 'end') }
          )
            ->pack(-side => 'left');

  

  

##------------------------------------------------------------------------------
# frame in the middle     
my $frame_middle = $mw->Frame()
                      ->pack(-side=>'top',
                       -fill=>'both',
                       -expand=>'1',
                  );
##------------------------------------------------------------------------------
# Frame middle left
#
my $frame_left = $frame_middle->Frame(-relief=>"groove",
                                     -borderwidth => "2")
                             ->pack(-fill=>'both',
                        -expand=>"1", 
                                    -side=>"left",
                   );

  my $frame_retry = $frame_left->Frame
                               ->pack(
                                -fill=>'x');
    my $ch_retry = $frame_retry->Checkbutton(-text => "Retry:",                                       
                                             -anchor=>'w')
                               ->pack(
                                      -side=>'left',
                                      -fill=>'x');      
    my $ent_retry = $frame_retry->Entry(-width=>'2')
                                ->pack(-side=>"left",
                                 -fill=>'x',
                      );
    $ent_retry->insert (0,5);

  
  my $frame_mtime = $frame_left->Frame
                                 ->pack(
                                  -fill=>'x');
      my $ch_mtime = $frame_mtime->Checkbutton(-text => "Max time -m:",                                       
                                               -anchor=>'w')
                                 ->pack(
                                        -side=>'left',
                                        -fill=>'x');      
      my $ent_mtime = $frame_mtime->Entry(-width=>'4')
                                  ->pack(-side=>"left",
                                   -fill=>'x',
                        );
    $ent_mtime->insert (0,10);
    
  
  
    my $ch_globoff = $frame_left->Checkbutton(-text => "Globoff -g",                                       
                                             -anchor=>'w')
                               ->pack(                                      
                                      -fill=>'x');   
                                      
    my $ch_remote = $frame_left->Checkbutton(-text => "Remote-name -O",                                       
                                             -anchor=>'w')
                               ->pack(                                      
                                      -fill=>'x');                                             
    
     my $ch_crdirs = $frame_left->Checkbutton(-text => "Create dirs",                                       
                                                 -anchor=>'w')
                                   ->pack(                                          
                                          -fill=>'x');                                            
    
    
     my $ch_proxy;    
      $ch_proxy = $frame_left->Checkbutton(-text => "Use Proxy",
                                           -command => sub { 
                                if ($ch_proxy->{'Value'}) { config_proxy() }
                               },
                                           -anchor=>'w')
                             ->pack(
                                      -fill=>'x');
     

    

 


 
##------------------------------------------------------------------------------
# Frame middle right
#

my $frame_right= $frame_middle->Frame(-relief=>"groove",
                                     -borderwidth => "2")
                             ->pack(-fill=>'both',
                        -expand=>"1", 
                                    -side=>"left",
                   );

 my $ch_agent;
 my $ent_agent;
 my $frame_agent = $frame_right->Frame
                                ->pack(-fill=>'x',
        );
   $ch_agent = $frame_agent->Checkbutton(-text => "User-agent -A:",
                                       -command => sub { 
                         if ($ch_agent->{'Value'}) {
                                $ent_agent->configure('-state'=>'normal');
                   } else {
         $ent_agent->configure('-state'=>'disabled')
       }
                                 },
                                       -anchor=>'w')
                         ->pack(-fill=>'x',
                                    -side=>"left",
       );
 

    $ent_agent = $frame_agent->Entry(-width=>'5')
                                 ->pack(-side=>"left",
                                  -fill=>'x',
                            -expand=>'1',
                       );
    $ent_agent->insert('end',"Mozilla"); 
    $ent_agent->configure('-state'=>'disabled'); 



 



my $ent_outfile;    
  my $ch_outfile;   
 my $frame_outfile = $frame_right->Frame
                                ->pack(-fill=>'x',
        );
  $ch_outfile = $frame_outfile->Checkbutton(-text => "Output file -o:",
                                        -command => sub { 
       if ($ch_outfile->{'Value'}) {$ent_outfile->configure(-state=>'normal')}
                             else {$ent_outfile->configure(-state=>'disabled')};
                            },
                                        -anchor=>'w')
                          ->pack(-fill=>'x',
                                    -side=>"left",
            );
  $ent_outfile = $frame_outfile->Entry(
                             )
                           ->pack(
                                  -side=>'left',
                -fill=>'x',
                      -expand=>'1',
          );
  $ent_outfile->insert('end',"outfile"); 
  $ent_outfile->configure('-state'=>'disabled'); 


   my $ch_refer;    
   my $ent_refer;   
   my $frame_refer = $frame_right->Frame
                                  ->pack(-fill=>'x',
          );
   $ch_refer = $frame_refer->Checkbutton(-text => "Referer -e:",
                                          -command => sub { 
         if ($ch_refer->{'Value'}) {$ent_refer->configure(-state=>'normal')}
                               else {$ent_refer->configure(-state=>'disabled')};
                              },
                                          -anchor=>'w')
                            ->pack(-fill=>'x',
                                      -side=>"left",
              );
       $ent_refer = $frame_refer->Entry()
                                ->pack(
                                    -side=>'left',
                        -expand=>'1',
         -fill=>'x');
  $ent_refer->configure('-state'=>'disabled'); 
  

 
  my $ch_addpar;    
  my $ent_addpar;   
  my $frame_addpar = $frame_right->Frame
                                ->pack(-fill=>'x',
        );
  $ch_addpar = $frame_addpar->Checkbutton(-text => "Additional Param. :",
                                        -command => sub { 
       if ($ch_addpar->{'Value'}) {$ent_addpar->configure(-state=>'normal')}
                             else {$ent_addpar->configure(-state=>'disabled')};
                            },
                                        -anchor=>'w')
                          ->pack(-fill=>'x',
                                    -side=>"left",
            );
     $ent_addpar = $frame_addpar->Entry()
                              ->pack(
                                  -side=>'left',
                      -expand=>'1',
       -fill=>'x');
  $ent_addpar->configure('-state'=>'disabled'); 


 my $frame_user = $frame_right->Frame
                              ->pack(-fill=>'x');
    $frame_user->Label( -text=>"HTTP-User:" )
               ->pack(-side=>"left");
    my $ent_user = $frame_user->Entry(-width=>'5')
                              ->pack(-side=>"left",
                               -fill=>'x',
                                     -expand=>'1');

  my $frame_passw = $frame_right->Frame
                               ->pack(-fill=>'x');
    $frame_passw->Label( -text=>"HTTP-Password:" )
                ->pack(-side=>"left");
    my $ent_passw = $frame_passw->Entry(-width=>'10',
                                         -show=>'*')
                                ->pack(-side=>"left",
                                 -fill=>'x',
                           -expand=>'1',
                            );

#------------------------------------------------------------------------------
# Frame action buttons    bottom
#
my $frame_action = $mw->Frame(-relief=>"groove",
                              -borderwidth => "2")

                      ->pack(-side => 'top',
                             -fill=>'x',
                 -expand=>'1');

  my @buttons = (
    ['START curl' => sub { &start_curl() }],
    ['QUIT' => sub { exit }],
    ['SAVE Sett.' => sub { &save_settings() }],
    ['LOAD Sett.' => sub { &load_settings() }],
    ['About' => sub { &about() }],
  );
  foreach my $button (@buttons) {
    my $b = $frame_action->Button(
                                  -text => $button->[0],
                                  -command => $button->[1],
                           #      -width => 10,
                           );
   $b->pack(-side => 'left',
            -fill=>'x',
            -expand=>'1');
  }




MainLoop;

#------------------------------------------------------------------------------
# Start curl                                            
#------------------------------------------------------------------------------
sub start_curl {

  &check_options();

  system ("curl", @options);

  print "curl::GUI execution finished with command:\n";
  print "curl @options\n";
  print "End of command.\n";

}

#------------------------------------------------------------------------------
# Check options                                         
#------------------------------------------------------------------------------
sub check_options {
  # we have to collect all options
  # we do it the same manner as the wget-documentation
  # and put the data in one array
    
  my $entry;
    @options = ();  # empty array

# left side 
#
  
  if ($ch_retry  ->{'Value'})  {
    $entry = $ent_retry->get;
    push (@options, "--retry");
    push (@options, "$entry");
  };
  
  if ($ch_mtime  ->{'Value'})  {
      $entry = $ent_mtime->get;
      if ($entry) { push (@options, "-m$entry") };
  };
  
  if ($ch_crdirs ->{'Value'})  {
       push (@options, "--create-dirs");
  };
  
  if ($ch_remote ->{'Value'})  {
         push (@options, "-O");
    };
  
 if ($ch_globoff  ->{'Value'})  {
        push (@options, "-g");
  };
  

  if ($ch_proxy->{'Value'})  { 
    if ($proxy_user) { push(@options, "-U$proxy_user:$proxy_passw") };
    
    push(@options, "-x$proxy_url:$proxy_port");
  };
  
  $entry = $ent_user->get;
    if ($entry) {
      my $passwd = $ent_passw->get;
      push(@options, "-u$entry:$passwd");    
    };

  
  # right side
  
  if ($ch_agent  ->{'Value'})  {
        $entry = $ent_agent->get;
        push (@options, "-A$entry");
    };
 
      
    if ($ch_outfile->{'Value'})  {
      $entry = $ent_outfile->get;
      push (@options, "-o$entry") ;
    };
    
  if ($ch_refer->{'Value'})  {
        $entry = $ent_refer->get;
        push (@options, "-e$entry") ;
    };


  if ($ch_addpar->{'Value'})  {
    $entry = $ent_addpar->get;
    if ($entry) {push(@options, "$entry")};
  };

    
      $entry = $ent_url->get;
      my @url = split / /, $entry ;  
      push(@options, "@url");
    



} 

#------------------------------------------------------------------------------
# Save Settingfile                                      
#------------------------------------------------------------------------------
sub save_settings {
  

  my $filename = $mw->getSaveFile(
          -filetypes        =>[
       ['curlguirc',   ['*rc', '.rc']],
       ['Text Files',  ['.txt', '.text']],
           ], 
          -initialdir       => ".",
          -initialfile      => "curlguirc",
          -title            => "Save settings",
                      );

  if ($filename) {
    open SETTING, ">$filename"
          or warn "Can not open curlguirc!";

    &check_options();

    foreach (@options) {
      print SETTING "$_\n";
    }

    close SETTING;
  }
}

#------------------------------------------------------------------------------
# Load Settingfile                                      
#------------------------------------------------------------------------------
sub load_settings {

   my $filename = $mw->getOpenFile(
          -filetypes        =>[
       ['curlguirc',   ['*rc', '.rc']],
       ['Text Files',  ['.txt', '.text']],
           ], 
          -initialdir       => ".",
          -initialfile      => "curlguirc",
          -title            => "Load settings",
                       );

if ($filename) {
  open SETTING, "<$filename"
        or warn "Can not open curlguirc!";


# reset all settings
  {
  $ch_agent->deselect;
  $ent_agent->configure(-state=>'normal');
  $ent_agent->delete(0,'end');
  $ent_agent->insert('end',"Mozilla");
  $ch_outfile->deselect;
  $ent_outfile->configure(-state=>'normal');
  $ent_outfile->delete(0,'end');
  $ent_outfile->insert('end',".wget-list");
  
  $ch_retry->deselect;
  $ent_retry->delete(0,'end');
  
  $ch_mtime->deselect;
  $ent_mtime->delete(0,'end');
  
  $ch_crdirs->deselect;
  $ch_globoff->deselect;
  $ch_remote->deselect;
  
  $ent_user->delete(0,'end');
  $ent_passw->delete(0,'end');
  
  $ch_addpar->deselect;
  $ent_addpar->delete(0,'end');
  
  $ch_refer->deselect;
  $ent_refer->configure(-state=>'normal');
  $ent_refer->delete(0,'end');
    
  
# 
  $proxy_user="";
  $proxy_passw="";
  $proxy_port="";
#  
    $ent_url->delete(0,'end');
  
  
  }


  while (<SETTING>) {
    chomp;

    SWITCH:{
# logging
      /^-A(.*)$/   && do {
                          $ch_agent->select;
                          $ent_agent->delete(0,'end');
                          $ent_agent->insert('end',$1);
                          last SWITCH;
                      };
      /^-o(.*)$/   && do {
                          $ch_outfile->select;
                          $ent_outfile->delete(0,'end');
                          $ent_outfile->insert('end',$1);
                          last SWITCH;
                      };
# download
      /^--retry$/  && do {
                          # don't work properly bec. of two lines in rcfile
                          $ch_retry->select;
                          $ent_retry->insert('end',"5");
                          last SWITCH;
                      };
      /^-m(\d+)$/  && do {
                          $ch_mtime->select;
                          $ent_mtime->insert('end',$1);
                          last SWITCH;
                      };
      /^-e(.*)$/  && do {
                           $ch_refer->select;
                           $ent_refer->insert('end',$1);
                           last SWITCH;
                      };
      /^-g$/       && do {
                          $ch_globoff->select;                                
                          last SWITCH;
                      };
      /^-O$/       && do {
                          $ch_remote->select;                                
                          last SWITCH;
                      };               
      /^--create-dirs$/       && do {
                          $ch_crdirs->select;                                
                          last SWITCH;
                      };               
                      
      /^-u(.*):(.*)$/  && do {
                          $ent_user->insert('end',$1);
                          $ent_passw->insert('end',$2);
                          last SWITCH;
                      };
      
# http          
      /^-U(.*):(.*)$/   && do {
                          $proxy_user=$1;
                          $proxy_passw=$2;
                          last SWITCH;
                      };
      
      /^-x(.*):(.*)$/       && do {
                          $proxy_url=$1;
                          $proxy_port=$2;
                          $ch_proxy->select;
                          last SWITCH;
                      };


# URL
      /^(http.*)$/   && do {
                                  $ent_url->delete(0,'end');
                          $ent_url->insert('end',$1);
                          last SWITCH;
                      };
#

    }
  }
  close SETTING;
}
}
#------------------------------------------------------------------------------
# Configure Proxy                                       
#------------------------------------------------------------------------------
sub config_proxy {
  # open new window                        
  
  my $top_proxy = $mw->Toplevel(
                                -title=>'Configure Proxy',
                       );

    my $frame_puser = $top_proxy->Frame()
                                ->pack(-fill=>'x');
      $frame_puser->Label( -text=>"Proxy User:" )
                  ->pack(-side=>"left");
      my $ent_puser = $frame_puser->Entry(-width=>"5",
                                          -textvariable=>\$proxy_user,
                  )
                                  ->pack(-side=>"left",
                                     -fill=>'x',
                             -expand=>'1'
                        );

    my $frame_ppassw = $top_proxy->Frame
                                 ->pack(-fill=>'x');
      $frame_ppassw->Label( -text=>"Proxy Password:" )
                   ->pack(-side=>"left");
      my $ent_ppassw = $frame_ppassw->Entry(-width=>"12",
                                            -textvariable=>\$proxy_passw,
                    )
                                    ->pack(-side=>"left",
                                     -fill=>'x',
                               -expand=>'1'
                          );

    $top_proxy->Label( -text=>"Proxy URL:",
                       -anchor=>'w')
              ->pack(-fill=>'x');
    my $ent_purl = $top_proxy->Entry(
                                     -textvariable=>\$proxy_url,
             )
                             ->pack(-fill=>'x');

    my $frame_pport = $top_proxy->Frame
                                ->pack(-fill=>'x');
      $frame_pport->Label( -text=>"Proxy Port:" )
                  ->pack(-side=>"left");
      my $ent_pport = $frame_pport->Entry(-width=>"12",
                                          -textvariable=>\$proxy_port,
                  )
                                  ->pack(-side=>"left",
                                   -fill=>'x',
                             -expand=>'1'
                        );

    my $frame_butt = $top_proxy->Frame
                               ->pack(
                                  -fill=>'x',
                                -expand=>'1',
                           );
      $frame_butt->Button(
                          -text => "OK",
                          -command => sub { $top_proxy->destroy }
       )
                 ->pack(-side => 'left',
                        -fill=>'x',
                  -expand=>'1',
             );
      $frame_butt->Button(
                          -text => "Clear",
                          -command => sub {
                     $proxy_user="";
                     $proxy_passw="";
                     $proxy_url="";
                     $proxy_port="";
                          }
       )
                 ->pack(-side => 'left',
                    -fill=>'x',
                  -expand=>'1',
        );


}
#------------------------------------------------------------------------------
# About                                       
#------------------------------------------------------------------------------
sub about {
  # open new window                        
  
  my $text = << '  END_OFF_TEXT';
  curl::gui

  A graphical user interface for curl (download only)
 
  Copyright (C) 2007 Rudolf Martin 
 
  This program is free software; you can redistribute
  it and/or modify it under the terms of the
  GNU General Public License as published by the
  Free Software Foundation.
 
  This program is distributed in the hope that it will
  be useful, but WITHOUT ANY WARRANTY; without even the
  implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details. 
   
  Homepage: www.martin-achern.de/wgetgui/        
  Email: wgetgui@martin-achern.de
 
  END_OFF_TEXT

  my $top_about = $mw->Toplevel(
                                -title=>'About wget::gui',
                       );

  my $text_about = $top_about->Text(
                                    -width=>60,
                   )
                             ->pack();
  $text_about->insert("end", $text); 
  
  $text_about->configure(-state=>'disabled'); 


  $top_about->Button(
                     -text => "OK",
                     -command => sub { $top_about->destroy }
          )
            ->pack();

}
#------------------------------------------------------------------------------
#------------------------------------------------------------------------------
# History
#
# 2007/05/08 Start of Projet
#
#
