#!/usr/bin/perl
#------------------------------------------------------------------------------
# fix_picnum
# A graphical tool to extend numbers in picture-filenames to a given lenght     
#
# Copyright (C) 2007 Rudolf Martin 
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
# more details. 
#
# Homepage: www.martin-achern.de/wgetgui/                  
# Email: wgetgui@martin-achern.de
#
#------------------------------------------------------------------------------


use strict;
use Tk;
use File::Find;

my $version="0.1beta";

my $mw = new MainWindow;
$mw->title("fix_picnum   ".$version);

my $dir;
my $len;
my $work;

my $frame_dir = $mw->Frame()
                   ->pack(-side => 'top',
                          -fill=>'x');
  $frame_dir->Label(-text => "Extend numbers in picture-filenames to a given lenght.")
             ->pack();                        
                          
  $frame_dir->Label(-text => "Dir:")
             ->pack(-side => 'left');
  my $ent_dir = $frame_dir->Entry(-width => '50',)
                          ->pack(-side => 'left',
                                 -fill=>'x',
                     -expand=>'1',
                            );

  $frame_dir->Button(-text => "Clear",
                     -command => sub { $ent_dir->delete('0', 'end') }
              )
              ->pack(-side => 'left');
  $frame_dir->Button(-text => "Choose",
                               -command => sub {
                                        my $dir = $mw->chooseDirectory(
                                                               -initialdir => ".",
                                                               -title => "Choose directory",
     #                                                         -mustexist => '1',                           
                                               ); 
                              
                                        $ent_dir->delete(0,'end');
                                        $ent_dir->insert('end',$dir);                            
                               
                                           }
              )
            ->pack(-side => 'left');   

            

my $frame_len = $mw->Frame()
                   ->pack(-side => 'top',
                          -fill=>'x',  
                     );


  $frame_len->Label(-text => "Lenght of number in filename:",
                    -anchor=>'w'
              )
             ->pack(-fill=>'x',
                    -side => 'left',);

 
  my $scale_len = $frame_len->Scale(-from=>1, -to=>5,
                                       -orient=>'horizontal',                                      
                                )
                         ->pack(-side => 'left',);
  $scale_len->set('2');

my $ch_dir = $mw->Checkbutton(-text => "Change directory names",
                                            -anchor=>'w')
                              ->pack(-fill=>'x');           
            


my $frame_butt = $mw->Frame()                            
                    ->pack(-side => 'top',
                           -fill=>'x',
                           -expand=>'1');
  $frame_butt->Button(-text => "Start",
                      -command => sub { 
                                   $dir = $ent_dir->get;
                                   $len = $scale_len->get;
                                   $work=1;
                                   find(\&wanted, $dir);
                                   print "end\n";
                                 }
               )
             ->pack(-side => 'left',
                    -fill=>'x',
                    -expand=>'1');
  $frame_butt->Button(-text => "Preview",
                     -command => sub { 
                                   $dir = $ent_dir->get;
                                   $len = $scale_len->get;
                                   $work=0;
                                   find(\&wanted, $dir);
                                   print "end\n";
                                 }
               )
             ->pack(-side => 'left',
                    -fill=>'x',
                    -expand=>'1');               
  $frame_butt->Button(-text => "Quit",
                      -command => sub { exit }
               )
             ->pack(-side => 'left',
                    -fill=>'x',
                    -expand=>'1');
                 
  $frame_butt->Button(-text => "About",
                      -command => sub { about() }
               )
             ->pack(-side => 'left',
                    -fill=>'x',
                    -expand=>'1');                 

MainLoop;

#------------------------------------------------------------------------------
# wanted                          
#------------------------------------------------------------------------------
sub wanted {
  # $_ is set to the current file name 
  # $File::Find::dir is set to the current directory 
  # $File::Find::name is set to "$File::Find::dir/$_" 
  # you are chdir()'d to $File::Find::dir
  
  my $format= "%0".$len."d";
  
  if ($ch_dir->{'Value'}) {  
    # directory
    if ( (-d) && (/^(\d+)(.*)/) ) {
      # number at beginning       
      my $new = sprintf "$format%s", $1,$2;
      if ( length($1) lt $len) {  
            print "Directory $File::Find::name --> $new\n";            
            if ($work) {  rename($_,$new); }
      }      
    }
    return;
  }
  
  
  # only operate on picture files
  /\.(jpg|gif|tif|png)$/i or return;  
  
   
    
  if ( /^\d+/ ) {  
    #  number at beginning                   
    my $new = sprintf "$format%s", $&, $';        
    if ( length($&) lt $len) {  
      print "$File::Find::name --> $new\n";        
      if ($work) {  rename($_,$new); }
    }
  }
  
  elsif ( /(\d+)(\....)/ ) {  
    #  number at end                     
    my $new = sprintf "%s$format%s", $`, $1, $2;          
    if ( length($1) lt $len) {  
      print "$File::Find::name --> $new\n";          
      if ($work) {  rename($_,$new); }
    }          
  }
        
  elsif ( /\d+/ ) {  
    #  first number in middle                    
    my $new = sprintf "%s$format%s", $`, $&, $';            
    if ( length($&) lt $len) {  
      print "$File::Find::name --> $new\n";            
      if ($work) {  rename($_,$new); }
    }            
  }  
}  
#------------------------------------------------------------------------------
# About                                       
#------------------------------------------------------------------------------
sub about {
  # open new window                        
  
  my $text = << '  END_OFF_TEXT';
  fix_picnum

  A graphical tool to extend numbers in picture-filenames
  to a given lenght 
  
  Works with: jpg, gif, tif, png  
  Handles all matching files in a directorytree
  Handles numbers at every position in the filename.
  ( 1foo.jpg bar2.jpg foo3bar.jpg )
 
  Copyright (C) 2007 Rudolf Martin 
 
  This program is free software; you can redistribute
  it and/or modify it under the terms of the
  GNU General Public License as published by the
  Free Software Foundation.
 
  This program is distributed in the hope that it will
  be useful, but WITHOUT ANY WARRANTY; without even the
  implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details. 
       
  Homepage: www.martin-achern.de/wgetgui/        
  Email: wgetgui@martin-achern.de
 
  END_OFF_TEXT

  my $top_about = $mw->Toplevel(
                                -title=>'About wget::gui',
                       );

  my $text_about = $top_about->Text(
                                    -width=>60,
                                    -height=>25,
                   )
                             ->pack();
  $text_about->insert("end", $text); 

  $text_about->configure(-state=>'disabled'); 

  $top_about->Button(
                     -text => "OK",
                     -command => sub { $top_about->destroy }
          )
            ->pack();

}
#------------------------------------------------------------------------------
