#!/usr/bin/perl 
#------------------------------------------------------------------------------
# IVdownloader
#
# A graphical user interface to
# download images from Imagevenue.com with wget
#
# Copyright (C) 2007 Rudolf Martin 
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
# more details. 
#
# Homepage: www.martin-achern.de/wgetgui/ 
# Email: wgetgui@martin-achern.de
#
#------------------------------------------------------------------------------

use Tk;
use strict;
use warnings;
use Cwd;
use Tk::ProgressBar;

my $version="0.2beta";

my $linux;
if ( $^O =~ /linux/) {
  $linux=1; # 1=Linux  
} else {
  $linux=0; # 0=Windoze
}


my $proxy_url="192.168.100.240";
my $proxy_port="8080";
my $proxy_user;
my $proxy_passw;

my @images;
my @startoptions;
my @options;
my @links;

my $file;

my $safe=1;

my $dir = &Cwd::cwd();
my $workdir = &Cwd::cwd();

my $percent_done;

my $mode = 0;

#------------------------------------------------------------------------------
# GUI creation
my $mw = new MainWindow;
$mw->title("IVdownloader   ".$version);

#------------------------------------------------------------------------------
# frame on top
#
#------------------------------------------------------------------------------
# frame URL on the top
#
#------------------------------------------------------------------------------
# frame mode 
#
my $frame_mode = $mw->Frame(-relief=>"groove",
                           -borderwidth => "2")
                   ->pack(-side=>'top',
                    -fill=>'x',
               );

   my $frame_mode_url = $frame_mode->Frame()
                                 ->pack(-fill=>'x');
      $frame_mode_url->Radiobutton(-text=>"URL",
                              -width=>10,
                              -variable=>\$mode,
                              -anchor=>'w',
            -value=>"0")
                ->pack(-side=>"left");
    my $ent_url = $frame_mode_url->Entry(-width=>10,)
                          ->pack(-side => 'left',
                                 -fill=>'x',
                     -expand=>'1',
                            );
  

  
  my $frame_mode_file = $frame_mode->Frame()
                                 ->pack(-fill=>'x');
      $frame_mode_file->Radiobutton(-text=>"File",
                              -width=>10,
                              -variable=>\$mode,
                              -anchor=>'w',
            -value=>"1")
                ->pack(-side=>"left");
    my $ent_file = $frame_mode_file->Entry()
                          ->pack(-side => 'left',
                                 -fill=>'x',
                     -expand=>'1',
                            );

  $frame_mode_file->Button(
                            -text => "Choose",
                            -command => sub {
                              
              $file = $mw->getOpenFile(
                                          -initialdir => ".",
                                          -title => "Choose HTML-File",
                                          -filetypes        =>[
                                                 ['html',   ['.html', '.htm']],
                                                 ['All Files',  ['.*']],
           ], 
                                          
                                          
                                          
                             ); 
                         $ent_file->delete('0', 'end');
                         $ent_file->insert('end', $file);
                                   
                                          }
         )
                   ->pack(-side => 'left',
                          -fill=>'x',
                    -expand=>'0',
             );
  



my $frame_dir = $mw->Frame()
                     ->pack(
                             -fill=>'x',
                             -expand=>'0',
                     );
  $frame_dir->Label(-text => "Safe to Directory:")
            ->pack(-side=>'left',);
             
  my $ent_dir = $frame_dir->Entry(-width => '10',)
                          ->pack(
                           -side=>'left', 
                                  -fill=>'x',
                                  -expand=>'1',
                            );            
  $frame_dir->Button(
                            -text => "Choose",
                            -command => sub {
                              
              $dir = $mw->chooseDirectory(
                                          -initialdir => ".",
                                          -title => "Choose directory",
                             ); 
                         $ent_dir->delete('0', 'end');
                         $ent_dir->insert('end', $dir);
                                   
                                          }
         )
                   ->pack(-side => 'left',
                          -fill=>'x',
                    -expand=>'0',
             );



 
#------------------------------------------------------------------------------
# frame on the left side
#


my $frame_mid = $mw->Frame()
                   ->pack(
                           -fill=>'x',
                           -expand=>'0',
                     );



  my $frame_left = $frame_mid->Frame()
                    ->pack(
                            -side=>'left',
                           -fill=>'y',
                           -expand=>'0',
                       );
        
      
  my $ch_proxy;   
  $ch_proxy = $frame_left->Checkbutton(-text => "Use Proxy",
                                       -command => sub { 
                            if ($ch_proxy->{'Value'}) { config_proxy() }
                           },
                                       -anchor=>'w')
                         ->pack(-fill=>'x');   
                         
  
   my $frame_user = $frame_left->Frame
                                ->pack(-fill=>'x');
      $frame_user->Label( -text=>"User:" )
                 ->pack(-side=>"left");
      my $ent_user = $frame_user->Entry(-width=>'5')
                                ->pack(-side=>"left",
                                 -fill=>'x',
                                       -expand=>'1');
  
    my $frame_passw = $frame_left->Frame
                                 ->pack(-fill=>'x');
      $frame_passw->Label( -text=>"Password:" )
                  ->pack(-side=>"left");
      my $ent_passw = $frame_passw->Entry(-width=>'5',
                                           -show=>'*')
                                  ->pack(-side=>"left",
                                   -fill=>'x',
                             -expand=>'1',
                            );
  
  
  
  
  
  
   my $progressbar = $frame_left->ProgressBar(
                        -width => 20,    # height for horizontal
                  -length => 180,          # width  for horizonzal
                  -anchor => 'w',         # horizontal
                  -from => 0,
                  -to => 100,
                  -blocks => 1,
                  -colors => [0, 'green', 50, 'yellow' , 80, 'red'],
                 -variable => \$percent_done
               )
                     ->pack(
                                 -side=>'bottom',
                                 -fill=>'x');       
    $frame_left->Label(-text => "Progressbar:")
            ->pack(-side=>'bottom',);    

#------------------------------------------------------------------------------
# frame on the right side
#
my $frame_right = $frame_mid->Frame()
            ->pack(
             -side=>'right',
              -fill=>'y',
              -expand=>'0',
        );

   $frame_right->Label(-text => "Image links:")
               ->pack();    


   my $txt_images = $frame_right->Scrolled('Text', -scrollbars => 'osoe',
                                                      -width=>'40',
                                                      -height=>'30',
                                                      -wrap=>'none',
                                     )
                                   ->pack(
                                          -fill=>'x',
                                          -expand=>'1',
                         );
    

    
      
 
#-----------------------------------------------------------------------------
# frame on the bottom
#      

my $frame_butt = $mw->Frame
                             ->pack(
                                 -fill=>'x',
                               -expand=>'1',
                         );
      $frame_butt->Button(
                         -text => "Import links",
                          -command => sub {
              if ($mode==0) {                         
                &import_links();
              } else {
                &read_links();
              };
                            
              my $input="";
              foreach (@links) {
                $input .= "$_\n";
              }
              $txt_images->delete('1.0', 'end');
              $txt_images->Contents($input); 
                                                            }
       )
                 ->pack(-side => 'left',
                        -fill=>'x',
                        -expand=>'1',
             );                                 
      $frame_butt->Button(
                          -text => "Download now",
                          -command => sub {
                          &start_download();
                          @links=();
                    }
       )
                 ->pack(-side => 'left',
                        -fill=>'x',
                  -expand=>'1',
             );
      
      $frame_butt->Button(
                          -text => "Clear",
                          -command => sub {
                               $ent_url->delete('0', 'end');                         
                               
                               $file="";
                               $ent_file->delete('0', 'end');
                               
                               $dir="";   
                               $ent_dir->delete('0', 'end');
                               
                               @links=();                 
                               $txt_images->delete('1.0', 'end');                                 
                                        }
       )
                 ->pack(-side => 'left',
                        -fill=>'x',
                  -expand=>'1',
             );
             
    $frame_butt->Button(
                               -text => "Quit",
                               -command => sub {
                              exit
                                           }
            )
                      ->pack(-side => 'left',
                             -fill=>'x',
                       -expand=>'1',
                  );        
  
     $frame_butt->Button(
                              -text => "About",
                               -command => sub {
                                        &about();                                        
                                                                 }
            )
                      ->pack(-side => 'left',
                             -fill=>'x',
                       -expand=>'1',
             );  
  





MainLoop;

#------------------------------------------------------------------------------
# import links                  
#------------------------------------------------------------------------------
sub import_links {
  # check wget
  my $output = `wget -V`;
  unless ($output) {
    print "Wget not found! Check path to wget!\n";
    return;
  }
  
  # get the sourcepage and extract the imagevenue-links
  @links=();
  my $url = $ent_url->get;
  &check_options();   
# push( @options, "--referer=imagevenue.com"); 
  push( @options, "--output-document=-");
  push( @options, $url);    # URL

  print "wget @options\n";

  if ($linux) {
    &import_linux;
  } else {
    &import_win;
  }  
 
  #print "@links\n";
#------------------------------------------------------------------------------
  sub import_linux{
    my $pid = open ( my $readme, "-|", "wget", @options )
                           or die "Couldn't fork: $!\n";
    while (<$readme>) {
      # print;
# <a href="http://anonym.to/?http://img144.imagevenue.com/img.php?image=79330_101_123_1188lo.jpg" target="_blank">
      while (/<a\s*href\s*=\s*\"(.*?)\"/igs) {        
        my $link = $1;
  
        print "$link\n";
        
        $link =~ tr$http://anonym.to/?$$;
    
        $link =~ /imagevenue/ or next;
        $link =~ /img.php/ or next;
    
        push (@links, $link);
      }
    }
    close $readme;
  }
#------------------------------------------------------------------------------  
  sub import_win{
    my @output = `wget @options`;   # collect output into array, one line per element
                                      # uses the shell --> unsafe      
        
    foreach (@output) {
      print;
      while ( /<a\s*href\s*=\s*\"(.*?)\"/igs) {     
      
        my $link = $1;
        
        print "$link\n";
        
        $link =~ tr$http://anonym.to/?$$;
        
        $link =~ /imagevenue/ or next;
        $link =~ /img.php/ or next;
    
        push (@links, $link);
      }                     
    }        
  }

}

#------------------------------------------------------------------------------  
sub read_links{
    
     
  if ($file) {
    open FILE, "<$file"
      or warn "Can not open $file!";
  }
  
  while (<FILE>) {
    chomp;      
    
      #print;
      while ( /<a\s*href\s*=\s*\"(.*?)\"/igs) {     
      
        my $link = $1;
        
        #print "$link\n";
        
        $link =~ s$http://anonym.to/\?$$;
        #$link =~ tr/anonym//g;
        
        
        $link =~ /imagevenue/ or next;
        $link =~ /img.php/ or next;
    
        push (@links, $link);
      }                     
  }        
  close FILE;
}



#------------------------------------------------------------------------------
# Start download                  
#------------------------------------------------------------------------------
sub start_download {

  

  my $total = @links;
   
  my $progress;
  
  foreach (@links) {
    # wget the imagevenue-site and extract the image-filename
    
    my $source;

    m#//(.*imagevenue.*)/#;

    my $main=$1;

    print $main;

    &check_options();   
    push( @options, "--output-document=-");
    push( @options, "--referer=imagevenue.com");    
    push( @options, $_);    # URL
    
      if ($linux) {
        $source = &import_name_linux;
      } else {
        $source = &import_name_win;
      }  
 
    $source =~ m#/.{5}_(.*?)$#;   # cut 6 digits from filename
    my $filename = $1;
    #print "filename= $filename\n";
      

  # wget the image
    
    &check_options();
    push( @options, "-nc");
    push( @options, "--referer=$main");
    if ($dir) {$filename = "$dir/$filename"}; 
    push( @options, "--output-document=$filename");    
    push( @options, "$main/$source");    # URL
   
    system ("wget", @options);
        
    print "Wget::GUI execution finished with command:\n";
    print "wget @options\n";
    print "End of command.\n";  
    
    $progress ++;

    $percent_done=$progress/$total*100;
    $progressbar->value($percent_done);
    $progressbar->update();
          
  }  # foreach



  $percent_done=0;
  # $progressbar->destroy;
  
  
  sub import_name_linux{
    my$pid = open ( my $readme, "-|", "wget", @options )
                                or die "Couldn't fork: $!\n";
      
    my $source;
    while (<$readme>) {
      #print;
      /SRC=\"(.*loc.*.jpg)\"/ or next;
      $source = $1;
      last;
    }
    close $readme;
    return $source;
  }
    
  sub import_name_win{
      my @output = `wget @options`;   # collect output into array, one line per element
                                        # uses the shell --> unsafe      
      my $source;    
      foreach (@output) {
        #print;
        /SRC=\"(.*loc.*.jpg)\"/ or next;
        $source = $1;
        last;
      } 
    return $source;
  }
}

#------------------------------------------------------------------------------
# Check options                                         
#------------------------------------------------------------------------------
sub check_options {
  # 
  # 
  # 
  my $entry;
  @options=();
  push( @options, "--user-agent=Mozilla");  
  push( @options, "--tries=2");

    $entry = $ent_user->get;
    if ($entry) {push(@options, "--user=$entry")};
  
    $entry = $ent_passw->get;
    if ($entry) {push(@options, "--password=$entry")};




  if ($ch_proxy->{'Value'})  { 
    # insert proxy-parameters         
    push(@options, "-e \"http_proxy=$proxy_url:$proxy_port\"");
    if ($proxy_user) {push(@options, "--proxy-user=$proxy_user")};
    if ($proxy_passw) {push(@options, "--proxy-password=$proxy_passw")};          
  }

  # directory

}

#------------------------------------------------------------------------------
# Configure Proxy                                       
#------------------------------------------------------------------------------
sub config_proxy {
  # open new window                        
  
  my $top_proxy = $mw->Toplevel(
                                -title=>'Configure Proxy',
                       );

    my $frame_puser = $top_proxy->Frame()
                                ->pack(-fill=>'x');
      $frame_puser->Label( -text=>"Proxy User:" )
                  ->pack(-side=>"left");
      my $ent_puser = $frame_puser->Entry(-width=>"5",
                                          -textvariable=>\$proxy_user,
                  )
                                  ->pack(-side=>"left",
                                     -fill=>'x',
                             -expand=>'1'
                        );

    my $frame_ppassw = $top_proxy->Frame
                                 ->pack(-fill=>'x');
      $frame_ppassw->Label( -text=>"Proxy Password:" )
                   ->pack(-side=>"left");
      my $ent_ppassw = $frame_ppassw->Entry(-width=>"12",
                                            -textvariable=>\$proxy_passw,
                    )
                                    ->pack(-side=>"left",
                                     -fill=>'x',
                               -expand=>'1'
                          );

    $top_proxy->Label( -text=>"Proxy URL:",
                       -anchor=>'w')
              ->pack(-fill=>'x');
    my $ent_purl = $top_proxy->Entry(
                                     -textvariable=>\$proxy_url,
             )
                             ->pack(-fill=>'x');

    my $frame_pport = $top_proxy->Frame
                                ->pack(-fill=>'x');
      $frame_pport->Label( -text=>"Proxy Port:" )
                  ->pack(-side=>"left");
      my $ent_pport = $frame_pport->Entry(-width=>"12",
                                          -textvariable=>\$proxy_port,
                  )
                                  ->pack(-side=>"left",
                                   -fill=>'x',
                             -expand=>'1'
                        );

    my $frame_butt = $top_proxy->Frame
                               ->pack(
                                  -fill=>'x',
                                -expand=>'1',
                           );
      $frame_butt->Button(
                          -text => "OK",
                          -command => sub { $top_proxy->destroy }
       )
                 ->pack(-side => 'left',
                        -fill=>'x',
                  -expand=>'1',
             );
      $frame_butt->Button(
                          -text => "Clear",
                          -command => sub {
                     $proxy_user="";
                     $proxy_passw="";
                     $proxy_url="";
                     $proxy_port="";
                          }
       )
                 ->pack(-side => 'left',
                    -fill=>'x',
                  -expand=>'1',
        );


}

#------------------------------------------------------------------------------
# About                                       
#------------------------------------------------------------------------------
sub about {
  # open new window                        
  
  my $text = << '  END_OFF_TEXT';
  IVdownloader

  A graphical user interface to     
  download images from Imagevenue.com with wget
  
  You can choose the URL of a posting in a messageboard,
  or a webpage with IVlinks.
  
  If the board is passwordprotected you can save the
  webpage with the IVlinks to your harddrive and select
  the downloaded file.  
  
  Copyright (C) 2007 Rudolf Martin 
 
  This program is free software; you can redistribute
  it and/or modify it under the terms of the
  GNU General Public License as published by the
  Free Software Foundation.
 
  This program is distributed in the hope that it will
  be useful, but WITHOUT ANY WARRANTY; without even the
  implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details. 
   
  Homepage: www.martin-achern.de/wgetgui/        
  Email: wgetgui@martin-achern.de
 
  END_OFF_TEXT

  my $top_about = $mw->Toplevel(
                                -title=>'About imagedownloader',
                       );

  my $text_about = $top_about->Text(
                                    -width=>60,
                   )
                             ->pack();
  $text_about->insert("end", $text); 
  
  $text_about->configure(-state=>'disabled'); 

  $top_about->Button(
                     -text => "OK",
                     -command => sub { $top_about->destroy }
          )
            ->pack();

}
#------------------------------------------------------------------------------
#------------------------------------------------------------------------------
# History
#
# 2007 April   Start of Projet
#
#
#


