#!/usr/bin/perl 
#------------------------------------------------------------------------------
# IVuploader
#
# A graphical user interface to
# upload images to Imagevenue.com with curl
#
# Copyright (C) 2007 Rudolf Martin 
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
# more details. 
#
# Homepage: www.martin-achern.de/wgetgui/ 
# Email: wgetgui@martin-achern.de
#
#------------------------------------------------------------------------------

use Tk;
use strict;
use warnings;
use Cwd;
use Tk::ProgressBar;

use Tk::JPEG;
use Tk::Photo;
use MIME::Base64;


my $version="0.5beta";


my $linux;
if ( $^O =~ /linux/) {
  $linux=1; # 1=Linux  
} else {
  $linux=0; # 0=Windoze
}

my $proxy_url="192.168.100.240";
my $proxy_port="8080";
my $proxy_user;
my $proxy_passw;

my @images;
my @startoptions;
my @options;
my @links;

my $safe=1;

my $imgdir = ".";
my $workdir = &Cwd::cwd();


#------------------------------------------------------------------------------
# start options
#

push (@startoptions,'-A "Mozilla"');   #0

push (@startoptions,"-F" );
push (@startoptions,"userfile[]=");    #2

push (@startoptions,"-F" );
push (@startoptions,"userfile[]=");    #4

push (@startoptions,"-F" );
push (@startoptions,"userfile[]=");    #6

push (@startoptions,"-F" );
push (@startoptions,"userfile[]=");    #8

push (@startoptions,"-F" );
push (@startoptions,"userfile[]=");    #10

push (@startoptions,"-F" );
push (@startoptions,"imgcontent=safe");  #12

push (@startoptions,"-F" );
push (@startoptions,"MAX_FILE_SIZE= ");  #14

push (@startoptions,"-F" );
push (@startoptions,"action=1");         #16

push (@startoptions,"-F" );
push (@startoptions,"img_resize=" );     #18

#push (@startoptions,"--trace-ascii");
#push (@startoptions,"tracesh");

#push (@startoptions,"-#");

push (@startoptions,"http://imagevenue.com/upload.php");



#------------------------------------------------------------------------------
# GUI creation
my $mw = new MainWindow;
$mw->title("IVuploader   ".$version);

#------------------------------------------------------------------------------
# frame on top
#
my $frame_top = $mw->Frame()
                   ->pack(
                           -fill=>'x',
                           -expand=>'0',
                     );

  $frame_top->Label(-text => "Directory:")
            ->pack(-side=>'left',);
             
  my $ent_dir = $frame_top->Entry(-width => '10',)
                          ->pack(
                           -side=>'left', 
                                  -fill=>'x',
                                  -expand=>'1',
                            );            

      
  $frame_top->Button(
                            -text => "Choose",
                            -command => sub { &choose_dir() }                      
                           )
                   ->pack(-side => 'left',
                          -fill=>'x',
                   
             );



my $frame_mid = $mw->Frame()
                   ->pack(
                           -fill=>'x',
                           -expand=>'0',
                     );


#------------------------------------------------------------------------------
# frame on the left side
#
  my $frame_left = $frame_mid->Frame()
                    ->pack(
                            -side=>'left',
                           -fill=>'y',
                           -expand=>'0',
                       );
  
  
  my $frame_ivopt = $frame_left->Frame(-relief=>"groove",
                                       -borderwidth => "2")
                               ->pack(-fill=>'x',
                                -expand=>"0",
                         );
  
  
  $frame_ivopt->Label( -text=>"IV options:",
                      -anchor=>'w',   )
                ->pack(-fill=>'x');     
  
  my $frame_radio = $frame_ivopt->Frame
                              ->pack(-fill=>'x');
    
    $frame_radio->Radiobutton(-text=>"Safe for work",
                              -variable=>\$safe,
                              -anchor=>'w',                              
                              -value=>"1")
                ->pack(-fill=>'x');
    $frame_radio->Radiobutton(-text=>"Not safe for work",
                              -variable=>\$safe,
                              -anchor=>'w',
                              -value=>"0")
                ->pack(-fill=>'x');
 

  my $frame_resize = $frame_ivopt->Frame
                               ->pack(
                                -fill=>'x');
    $frame_resize->Label( -text=>"Resize (largest side):" )
                 ->pack(
                        -side=>'left',
             );                
    my $ent_resize = $frame_resize->Entry(-width=>'8')
                                ->pack(-side=>"left",
                                 -fill=>'x',
                      );
                      
                      
  my $frame_opt = $frame_left->Frame(-relief=>"groove",
                                       -borderwidth => "2")
                               ->pack(-fill=>'x',
                                -expand=>"0",
                         );                    
                      
  $frame_opt->Label( -text=>"Other options:",
                      -anchor=>'w',   )
                ->pack(-fill=>'x');     
  

  my $frame_row = $frame_opt->Frame
                                 ->pack(
                                -fill=>'x');

  $frame_row->Label( -text=>"Images per row:" )
                ->pack(
                -side=>'left',
                );                
  my $scale_row = $frame_row->Scale(-from=>1, -to=>5,
                                       -orient=>'horizontal',
               )
                         ->pack(
                         -side=>'left',
                         );
  $scale_row->set('4');  
                
    
  my $ch_proxy;   
  $ch_proxy = $frame_opt->Checkbutton(-text => "Use Proxy",
                                       -command => sub { 
                            if ($ch_proxy->{'Value'}) { &config_proxy() }
                           },
                                       -anchor=>'w')
                         ->pack(-fill=>'x');   



  my $frame_save = $frame_opt->Frame
                                 ->pack(
                                -fill=>'x');


  my $ch_save = $frame_save->Checkbutton(-text => "Save links to file:",
                                       -anchor=>'w')
                         ->pack(-side=>'left',
       -fill=>'x');   
    my $ent_save = $frame_save->Entry(-width=>'10')
                                ->pack(-side=>"left",
                                 -fill=>'x',
                      );
    $ent_save->insert (0,'url.txt');

  $ch_save->select;                        


  my $can_image;
  my $ch_preview;
  $ch_preview = $frame_left->Checkbutton(-text => "Preview",
                                       -command => sub { 
                          if ($ch_preview->{'Value'}) {
                            &show_image;
                          } else {
                          $can_image->delete('all')
                          }
                                        },
                                       -anchor=>'w')
                         ->pack(-fill=>'x',);


# empty canvas
  $can_image = $frame_left -> Canvas ( -width => 250 , -height => 250 )  
                            ->pack; 




        
   my $progressbar = $frame_left->ProgressBar(
                        -width => 20,    # height for horizontal
                  -length => 180,          # width  for horizonzal
                  -anchor => 'w',         # horizontal
                  -from => 0,
                  -to => 100,
                  -blocks => 1,
                  -colors => [0, 'green', 50, 'yellow' , 80, 'red'],
                             )
                     ->pack(
                                 -side=>'bottom',
                                 -fill=>'x');       
    $frame_left->Label(-text => "Progressbar:")
            ->pack(-side=>'bottom',);    

#------------------------------------------------------------------------------
# frame on the right side
#
my $frame_right = $frame_mid->Frame()
            ->pack(
             -side=>'right',
              -fill=>'y',
              -expand=>'1',
        );
  $frame_right->Label( -text=>"Images to upload (editable):" )
                ->pack();   
   
  my $txt_images;
   
   
   
  my $frame_right_butt = $frame_right->Frame()
                         ->pack(
                                -fill=>'x',
                                -expand=>'1',
                         );    
  
   
    $frame_right_butt->Button(
                          -text => "Line del",
                          -command => sub {                                  
                             $txt_images->delete("insert linestart","insert lineend +1 chars");                       
                             &show_image;
                                      }
                       )
                     ->pack(-side => 'left',
                            -fill=>'x',
                            -expand=>'1',
                       );                     

      $frame_right_butt->Button(
                           -text => "Line up",
                           -command => sub {                                                                   
                              my $text = $txt_images->get("insert linestart","insert lineend");
                              $txt_images->delete("insert linestart","insert lineend +1 chars"); 
                              $txt_images->SetCursor("insert - 1 lines");
                              $txt_images->Insert("$text\n");
                              $txt_images->SetCursor("insert - 1 lines");                                                                                     
                              &show_image;
                                       }
                        )
                      ->pack(-side => 'left',
                             -fill=>'x',
                             -expand=>'1',
                        );                     
       $frame_right_butt->Button(
                             -text => "Line dwn",
                             -command => sub {                                                                   
                                my $text = $txt_images->get("insert linestart","insert lineend");
                                $txt_images->delete("insert linestart","insert lineend +1 chars"); 
                                $txt_images->SetCursor("insert + 1 lines");
                                $txt_images->Insert("$text\n");
                                $txt_images->SetCursor("insert - 1 lines");                                                                                     
                                &show_image;
                                         }
                          )
                        ->pack(-side => 'left',
                               -fill=>'x',
                               -expand=>'1',
                        );     
   
   
  $txt_images = $frame_right->Scrolled('Text', -scrollbars => 'oe',
                                                      -width=>'25',
                                                      -height=>'30',
                                                      -wrap=>'none',
                                     )
                                   ->pack(
                                          -fill=>'y',
                                          -expand=>'1',
                         );
    

   $txt_images->bind('<ButtonRelease-1>' => \&show_image); 
   $txt_images->bind('<Key-Up>'          => \&show_image); 
   $txt_images->bind('<Key-Down>'        => \&show_image); 
   
      
 
#-----------------------------------------------------------------------------
# frame on the bottom
#      

my $frame_butt = $mw->Frame
                             ->pack(
                                 -fill=>'x',
                               -expand=>'1',
                         );
      $frame_butt->Button(
                          -text => "Upload now",
                          -command => sub {
                          chdir($imgdir);  # change to image directory
                          &start_upload();
                          if (@links) {
                            my $fileaccess=0;
                            #save links to url.txt if possible
                            if ($ch_save->{'Value'}) {
            my $urlfile=$ent_save->get;
                              if ( open(FILE, ">>$urlfile") ) {
                                $fileaccess=1;
                                print FILE "@links\n";
              close FILE;
            }
          }
          &show_links($fileaccess);

        };
                          @links=();
                          chdir($workdir);  # change working directory
                    }
       )
                 ->pack(-side => 'left',
                        -fill=>'x',
                  -expand=>'1',
             );
    
    $frame_butt->Button(
                          -text => "Quit",
                          -command => sub {
                         exit
                                      }
       )
                 ->pack(-side => 'left',
                        -fill=>'x',
                  -expand=>'1',
             );        
    
     $frame_butt->Button(
                         -text => "Clear",
                          -command => sub {
                                   $txt_images->delete('1.0', 'end');
                                   $ent_dir->delete('0', 'end');
                                   @images=();
                                                            }
       )
                 ->pack(-side => 'left',
                        -fill=>'x',
                  -expand=>'1',
             );        
             
     $frame_butt->Button(
                              -text => "About",
                               -command => sub {
                                        &about();                                        
                                                                 }
            )
                      ->pack(-side => 'left',
                             -fill=>'x',
                       -expand=>'1',
             );  
  





MainLoop;


#------------------------------------------------------------------------------
# Start upload                  
#------------------------------------------------------------------------------
sub start_upload {

  

  my $output = `curl -V`;
  unless ($output) {
    push (@links, "Curl not found! Check path to curl!\n");
    print "Curl not found! Check path to curl!\n";
    return;
  }


  &check_options();

  my $row= $scale_row->get;
  my $counter=0;

  my $entry;
  $entry=$txt_images->Contents();
  @images = split(/\n/, $entry);
  # print "images = @images\n";
  my $total = @images;
   
  my $progress;
  
  foreach (@images) {
    
    unless (-f) {next}; # image don't exist
    
    
    
    
    # collect as much images as rows
    $progress ++;
    
    $progressbar->value($progress/$total*100);
    $progressbar->update();

    $counter ++;
    $options[0+$counter*2]="userfile[]=\@$_;type=image/jpeg"; 


    if ($counter==$row) {
      # upload the images in queue
      print "Upload image $progress of $total\n";
      if ($linux) {
        &image_upload_lin();   
      } else {
        &image_upload_win();  
      }  
      $counter=0;  # reset
      &check_options();
    }   

  }  # end foreach

  if ($counter>0) {
    #upload the rest
    print "Upload image $progress of $total\n";
      if ($linux) {
        &image_upload_lin();   
      } else {
        &image_upload_win();  
      }  
    $counter=0;  # reset
    &check_options();
  }

  $progressbar->value(0);
  
  # $progressbar->destroy;

}
# ------------------------------------------------------------
sub ReadImageData {
  my( $imageFile ) = @_;

  open( my $IMAGE, "<", $imageFile )
    or die "Error in reading image: $!\n";
  binmode( $IMAGE );
  local $/ = undef; # slurp mode

  # bild einlesen und MIME-encoden
   return MIME::Base64::encode_base64( <$IMAGE> );

  # close( $IMAGE ) ist nicht noetig wegen my $IMAGE
}; # ReadImageData
#------------------------------------------------------------------------------
# Check options                                         
#------------------------------------------------------------------------------
sub check_options {
  # 
  # 
  # 
    

  @options = @startoptions; 

  if ($ch_proxy->{'Value'})  { 
    # insert proxy-parameters before url
    my $url = pop (@options);
    
    push (@options, "-x \"$proxy_url:$proxy_port\"");
    if ($proxy_user) {push(@options, "-U \"$proxy_user:$proxy_passw\"")};
    
    push (@options, $url);
  }

  unless ($safe)  {
    $options[12]="imgcontent=notsafe"; 
  }

  my $entry = $ent_resize->get;
  if ($entry) {
    $options[18]="img_resize=$entry"; 
  }



}
#------------------------------------------------------------------------------
# image_upload Linux                                         
#------------------------------------------------------------------------------
sub image_upload_lin {
  # 
  # upload the images
  # uses pipe --> elegant and safe --> linuxlike

  
        # system ("curl", @options);
  
        my $pid = open ( my $readme, "-|", "curl", @options )
                          or die "Couldn't fork: $!\n";
        while (<$readme>) {
          #print;
          if ( /\[URL=/ ) {
            s#</textarea>##;
            push (@links, $_);
          }
        }
        close $readme;
  
        #print "upload finished with command:\n";
        #print "curl @options\n";
        #print "End of command.\n";
}
#------------------------------------------------------------------------------
# image_upload Windoze                    
#------------------------------------------------------------------------------
sub image_upload_win {
  # 
  # upload the images
  
  #system ("curl", @options);
  
  #sleep(2);  #test
  
  my @output = `curl @options`;   # collect output into array, one line per element
                                  # uses the shell --> unsafe      
    
  foreach (@output) {
           #print;
           if ( /URL=/ ) {
             s#</textarea>##;
             push (@links, $_);
           }
  }      
  
  #print "upload finished with command:\n";
  #print "curl @options\n";
  #print "End of command.\n";
}
#------------------------------------------------------------------------------
# showlinks                                       
#------------------------------------------------------------------------------
sub show_links {
  # open new window                        
  
  my $top_links = $mw->Toplevel(
                                -title=>'Links for messageboard',
                       );

  $top_links->Label(-text => "Copy (Right-Click) and paste the links in a messageboard")
            ->pack;

  if ( $_[0] ) {
    my $file=$ent_save->get;
    $top_links->Label(-text => "Links saved to $imgdir/$file")
            ->pack;
  }

 
  my $text_links = $top_links->Scrolled('Text', -scrollbars => 'oe',
                                                      -width=>'60',
                                                      -height=>'30',
                                                      -wrap=>'char',
                                     )
                             ->pack();
                             
  $text_links->insert("end", "@links\n"); 

  $text_links->selectAll;
  $text_links->clipboardColumnCopy;

  $top_links->Button(
                     -text => "OK",
                     -command => sub { $top_links->destroy }
          )
            ->pack();

}
#------------------------------------------------------------------------------
# showimage                                 
#------------------------------------------------------------------------------
sub show_image {

  unless ( $ch_preview->{'Value'} ) {return};
  
  my $image = $mw -> Photo ();
  my $thumb = $mw -> Photo ();
 
  my $imageFilename = $txt_images->get('insert linestart', 'insert lineend'  );
  
  $imageFilename =~ s/\s+$//g; # delete blanks at end 
      
  unless (-f "$imgdir/$imageFilename") {   
    $can_image->delete('all');
    return;
  }
  
  #print "==$imgdir/$imageFilename==\n";
  
  $image->read("$imgdir/$imageFilename", -format => 'jpeg');
  
  my $faktor;
  my $im_height = $image->height;
  my $im_width  = $image->width;
  
  if ($im_width gt $im_height) {
    $faktor = int( $im_width / 250 + 0.99);
  } else {
    $faktor = int( $im_height / 250 + 0.99);
  }
    
  $thumb->copy($image, -subsample => $faktor); # thumbnail
      
      
  $can_image->delete('all');    
  $can_image -> createImage ( 0 , 0 , -anchor => 'nw' , -image => $thumb ) ;      
  
  $can_image->createText(125, 240, -text => "Size = $im_width x $im_height", -anchor => 'center');  
}
#------------------------------------------------------------------------------
# Choose Directory                                      
#------------------------------------------------------------------------------
sub choose_dir {
  
  my $dir = $mw->chooseDirectory(
                                 -initialdir => "$imgdir",
                                 -title => "Choose directory",
                           ); 
                   
  unless ($dir) {return};       
                 
  $imgdir=$dir;
  $ent_dir->delete(0,'end');
  $ent_dir->insert('end',$imgdir);
                        
                              
   opendir(DIR, $imgdir);
   @images = grep { /\.jpg$/i } readdir(DIR);
   closedir(DIR);

   @images = sort @images;


   my $input="";
   foreach ( @images ) {
     $input .= "$_\n";
   }                               
                                 
   $txt_images->Contents($input);         


}
#------------------------------------------------------------------------------
# Configure Proxy                                       
#------------------------------------------------------------------------------
sub config_proxy {
  # open new window                        
  
  my $top_proxy = $mw->Toplevel(
                                -title=>'Configure Proxy',
                       );
                       
    $top_proxy->geometry("+".int($mw->x+100).
                           "+".int($mw->y+100));                      

    my $frame_puser = $top_proxy->Frame()
                                ->pack(-fill=>'x');
      $frame_puser->Label( -text=>"Proxy User:" )
                  ->pack(-side=>"left");
      my $ent_puser = $frame_puser->Entry(-width=>"5",
                                          -textvariable=>\$proxy_user,
                  )
                                  ->pack(-side=>"left",
                                     -fill=>'x',
                             -expand=>'1'
                        );

    my $frame_ppassw = $top_proxy->Frame
                                 ->pack(-fill=>'x');
      $frame_ppassw->Label( -text=>"Proxy Password:" )
                   ->pack(-side=>"left");
      my $ent_ppassw = $frame_ppassw->Entry(-width=>"12",
                                            -textvariable=>\$proxy_passw,
                    )
                                    ->pack(-side=>"left",
                                     -fill=>'x',
                               -expand=>'1'
                          );

    $top_proxy->Label( -text=>"Proxy URL:",
                       -anchor=>'w')
              ->pack(-fill=>'x');
    my $ent_purl = $top_proxy->Entry(
                                     -textvariable=>\$proxy_url,
             )
                             ->pack(-fill=>'x');

    my $frame_pport = $top_proxy->Frame
                                ->pack(-fill=>'x');
      $frame_pport->Label( -text=>"Proxy Port:" )
                  ->pack(-side=>"left");
      my $ent_pport = $frame_pport->Entry(-width=>"12",
                                          -textvariable=>\$proxy_port,
                  )
                                  ->pack(-side=>"left",
                                   -fill=>'x',
                             -expand=>'1'
                        );

    my $frame_butt = $top_proxy->Frame
                               ->pack(
                                  -fill=>'x',
                                -expand=>'1',
                           );
      $frame_butt->Button(
                          -text => "OK",
                          -command => sub { $top_proxy->destroy }
       )
                 ->pack(-side => 'left',
                        -fill=>'x',
                  -expand=>'1',
             );
      $frame_butt->Button(
                          -text => "Clear",
                          -command => sub {
                     $proxy_user="";
                     $proxy_passw="";
                     $proxy_url="";
                     $proxy_port="";
                          }
       )
                 ->pack(-side => 'left',
                    -fill=>'x',
                  -expand=>'1',
        );


}

#------------------------------------------------------------------------------
# About                                       
#------------------------------------------------------------------------------
sub about {
  # open new window                        
  
  my $text = << '  END_OFF_TEXT';
  IVuploader

  A graphical user interface to     
  upload images to Imagevenue.com with curl
 
  You can upload one directory at once.
  
  You get the imagelinks for a messageboard.

  Copyright (C) 2007 Rudolf Martin 
 
  This program is free software; you can redistribute
  it and/or modify it under the terms of the
  GNU General Public License as published by the
  Free Software Foundation.
 
  This program is distributed in the hope that it will
  be useful, but WITHOUT ANY WARRANTY; without even the
  implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details. 
   
  Homepage: www.martin-achern.de/wgetgui/        
  Email: wgetgui@martin-achern.de
 
  END_OFF_TEXT

  my $top_about = $mw->Toplevel(
                                -title=>'About imageuploader',
                       );
  $top_about->geometry("+".int($mw->x+10).
                           "+".int($mw->y+100));                      
                     
                       

  my $text_about = $top_about->Text(
                                    -width=>60,
                   )
                             ->pack();
  $text_about->insert("end", $text); 
  
  $text_about->configure(-state=>'disabled'); 

  $top_about->Button(
                     -text => "OK",
                     -command => sub { $top_about->destroy }
          )
            ->pack();

}
#------------------------------------------------------------------------------
#------------------------------------------------------------------------------
# History
#
# 2007 April   Start of Projet
#
#
#  progressbar optimized
#  append url.txt
#  preview
#  windowposition proxy about
#  move/del line


